---
title: Context · Cloudflare Style Guide
description: An introductory paragraph immediately following the page title that
  explains what users can expect from the following content, whether steps,
  concepts, FAQs, or reference materials.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/context/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/context/index.md
---

## Definition

An introductory paragraph immediately following the page title that explains what users can expect from the following content, whether steps, concepts, FAQs, or reference materials.

## Used in

[How to](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/how-to/), [Configuration](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/configuration/), [FAQ](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/faq/), [Concept](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/concept/), [Reference](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference/), [Tutorial](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/)

## Structure

### How to

An introductory paragraph on the following steps and what they will accomplish.

Provide context to the reader that is not in the section heading.

End with a colon or a period.

Use a colon if it immediately precedes the steps.

Use a period if there is more material (such as a note) between the context and the procedure.

Do not provide context for steps with a partial sentence that is completed by the numbered steps.

### Configuration

The context should be given in a paragraph right after the title. It should introduce the features, contextualize what type of configurations the user will encounter, and link to other relevant documentation.

### FAQ

An introductory paragraph on the section and what users can expect from it.

### Concept

Provide a brief description of why users should care about this information.

### Reference

Provide an introductory paragraph to explain how and why a user might utilize the information on this page.

### Tutorial

An introductory paragraph on the user's goal or job-to-be-done and how they'll accomplish that in the tutorial. Consider including the intended audience for the tutorial.
