---
title: Validation backoff schedule · Cloudflare SSL/TLS docs
description: Consider what happens if a domain control validation (DCV) fails
  and what schedule Cloudflare follows for new attempts and backoff.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/validation-backoff-schedule/
  md: https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/validation-backoff-schedule/index.md
---

Domain control validation (DCV) has to happen before a certificate authority (CA) will issue a certificate for a domain. If DCV fails during issuance or renewal, Cloudflare automatically retries it on a schedule.

If you use [Delegated DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/delegated-dcv/) or if [Cloudflare automatically performs DCV for you](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/), this page is only informational. If you have to manually perform DCV, consider the following sections about the validation schedule and remember that DCV tokens have a [fixed validity period](#dcv-tokens-validity).

Note

You can also request an immediate recheck by using the [Edit SSL Certificate Pack Validation Method endpoint](https://developers.cloudflare.com/api/resources/ssl/subresources/verification/methods/edit/), specifying the same `validation_method` as the [method](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/) you currently use.

***

## DCV tokens validity

The DCV process relies on tokens that are generated by the issuing certificate authority. These tokens have a validity period defined by each CA:

* Google Trust Services - 14 days
* Let's Encrypt - 7 days
* SSL.com - 14 days

After this period, DCV tokens expire as dictated by the [CA/B Baseline Requirements](https://cabforum.org/baseline-requirements-documents/), and new, valid tokens must be placed.

Warning

Tokens may also become invalid upon validation failure. For more details, refer to [Domain control validation flow](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/dcv-flow/#dcv-tokens).

***

## Successive checks function

Cloudflare caps the check backoff to a maximum of four hours to avoid the function growing exponentially, which would result in large gaps between checks towards the end of the month.

```txt
now() + min((floor(60 * pow(1.05, retry_attempt)) * INTERVAL '1 second'), INTERVAL '4 hours')
```

***

## Capped attempts reference table

As presented in the following table, most of the checks take place on the first day after the DCV token is generated.

In manual processes, it is possible that you fall behind schedule when you place the token, meaning that it may not be validated immediately.

In automatic processes, most validations complete within the first five minutes, unless there is a setup misconfiguration.

| Retry Attempt | In Seconds | In Minutes | In Hours |
| - | - | - | - |
| 0 | 60 | 1.000 | 0.016667 |
| 1 | 63 | 1.050 | 0.017500 |
| 2 | 66 | 1.100 | 0.018333 |
| 3 | 69 | 1.150 | 0.019167 |
| 4 | 72 | 1.200 | 0.020000 |
| 5 | 76 | 1.267 | 0.021111 |
| 6 | 80 | 1.333 | 0.022222 |
| 7 | 84 | 1.400 | 0.023333 |
| 8 | 88 | 1.467 | 0.024444 |
| 9 | 93 | 1.550 | 0.025833 |
| 10 | 242 | 4.033 | 0.067222 |
| 11 | 279 | 4.650 | 0.077500 |
| 12 | 321 | 5.350 | 0.089167 |
| 13 | 369 | 6.150 | 0.102500 |
| 14 | 424 | 7.067 | 0.117778 |
| 15 | 488 | 8.133 | 0.135556 |
| 16 | 561 | 9.350 | 0.155833 |
| 17 | 645 | 10.750 | 0.179167 |
| 18 | 742 | 12.367 | 0.206111 |
| 19 | 853 | 14.217 | 0.236944 |
| 20 | 981 | 16.350 | 0.272500 |
| 21 | 1129 | 18.817 | 0.313611 |
| 22 | 1298 | 21.633 | 0.360556 |
| 23 | 1493 | 24.883 | 0.414722 |
| 24 | 1717 | 28.617 | 0.476944 |
| 25 | 1975 | 32.917 | 0.548611 |
| 26 | 2271 | 37.850 | 0.630833 |
| 27 | 2612 | 43.533 | 0.725556 |
| 28 | 3003 | 50.050 | 0.834167 |
| 29 | 3454 | 57.567 | 0.959444 |
| 30 | 3972 | 66.200 | 1.103333 |
| 31 | 4568 | 76.133 | 1.268889 |
| 32 | 5253 | 87.550 | 1.459167 |
| 33 | 6041 | 100.683 | 1.678056 |
| 34 | 6948 | 115.800 | 1.930000 |
| 35 | 7990 | 133.167 | 2.219444 |
| 36 | 9189 | 153.150 | 2.552500 |
| 37 | 10567 | 176.117 | 2.935278 |
| 38 | 12152 | 202.533 | 3.375556 |
| 39 | 13975 | 232.917 | 3.881944 |
| 40 | 14400 | 240.000 | 4.000000 |
| 41 | 14400 | 240.000 | 4.000000 |
| 42 | 14400 | 240.000 | 4.000000 |
| 43 | 14400 | 240.000 | 4.000000 |
| 44 | 14400 | 240.000 | 4.000000 |
| 45 | 14400 | 240.000 | 4.000000 |
| 46 | 14400 | 240.000 | 4.000000 |
| 47 | 14400 | 240.000 | 4.000000 |
| 48 | 14400 | 240.000 | 4.000000 |
| 49 | 14400 | 240.000 | 4.000000 |
| 50 | 14400 | 240.000 | 4.000000 |
| 51 | 14400 | 240.000 | 4.000000 |
| 52 | 14400 | 240.000 | 4.000000 |
| 53 | 14400 | 240.000 | 4.000000 |
| 54 | 14400 | 240.000 | 4.000000 |
| 55 | 14400 | 240.000 | 4.000000 |
| 56 | 14400 | 240.000 | 4.000000 |
| 57 | 14400 | 240.000 | 4.000000 |
| 58 | 14400 | 240.000 | 4.000000 |
| 59 | 14400 | 240.000 | 4.000000 |
| 60 | 14400 | 240.000 | 4.000000 |
| 61 | 14400 | 240.000 | 4.000000 |
| 62 | 14400 | 240.000 | 4.000000 |
| 63 | 14400 | 240.000 | 4.000000 |
| 64 | 14400 | 240.000 | 4.000000 |
| 65 | 14400 | 240.000 | 4.000000 |
| 66 | 14400 | 240.000 | 4.000000 |
| 67 | 14400 | 240.000 | 4.000000 |
| 68 | 14400 | 240.000 | 4.000000 |
| 69 | 14400 | 240.000 | 4.000000 |
| 70 | 14400 | 240.000 | 4.000000 |
| 71 | 14400 | 240.000 | 4.000000 |
| 72 | 14400 | 240.000 | 4.000000 |
| 73 | 14400 | 240.000 | 4.000000 |
| 74 | 14400 | 240.000 | 4.000000 |
| 75 | 14400 | 240.000 | 4.000000 |
| 76 | 14400 | 240.000 | 4.000000 |
| 77 | 14400 | 240.000 | 4.000000 |
| 78 | 14400 | 240.000 | 4.000000 |
| 79 | 14400 | 240.000 | 4.000000 |
| 80 | 14400 | 240.000 | 4.000000 |
| 81 | 14400 | 240.000 | 4.000000 |
| 82 | 14400 | 240.000 | 4.000000 |
| 83 | 14400 | 240.000 | 4.000000 |
| 84 | 14400 | 240.000 | 4.000000 |
| 85 | 14400 | 240.000 | 4.000000 |
| 86 | 14400 | 240.000 | 4.000000 |
| 87 | 14400 | 240.000 | 4.000000 |
| 88 | 14400 | 240.000 | 4.000000 |
| 89 | 14400 | 240.000 | 4.000000 |
| 90 | 14400 | 240.000 | 4.000000 |
| 91 | 14400 | 240.000 | 4.000000 |
| 92 | 14400 | 240.000 | 4.000000 |
| 93 | 14400 | 240.000 | 4.000000 |
| 94 | 14400 | 240.000 | 4.000000 |
| 95 | 14400 | 240.000 | 4.000000 |
| 96 | 14400 | 240.000 | 4.000000 |
| 97 | 14400 | 240.000 | 4.000000 |
| 98 | 14400 | 240.000 | 4.000000 |
| 99 | 14400 | 240.000 | 4.000000 |
| 100 | 14400 | 240.000 | 4.000000 |
| 101 | 14400 | 240.000 | 4.000000 |
| 102 | 14400 | 240.000 | 4.000000 |
| 103 | 14400 | 240.000 | 4.000000 |
| 104 | 14400 | 240.000 | 4.000000 |
| 105 | 14400 | 240.000 | 4.000000 |
| 106 | 14400 | 240.000 | 4.000000 |
| 107 | 14400 | 240.000 | 4.000000 |
| 108 | 14400 | 240.000 | 4.000000 |
| 109 | 14400 | 240.000 | 4.000000 |
| 110 | 14400 | 240.000 | 4.000000 |
| 111 | 14400 | 240.000 | 4.000000 |
| 112 | 14400 | 240.000 | 4.000000 |
| 113 | 14400 | 240.000 | 4.000000 |
| 114 | 14400 | 240.000 | 4.000000 |
| 115 | 14400 | 240.000 | 4.000000 |
| 116 | 14400 | 240.000 | 4.000000 |
| 117 | 14400 | 240.000 | 4.000000 |
| 118 | 14400 | 240.000 | 4.000000 |
| 119 | 14400 | 240.000 | 4.000000 |
