---
title: JumpCloud (SAML) · Cloudflare One docs
description: JumpCloud provides SSO identity management. Cloudflare Access
  integrates with JumpCloud as a SAML identity provider.
lastUpdated: 2025-11-24T22:12:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/jumpcloud-saml/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/jumpcloud-saml/index.md
---

[JumpCloud](https://jumpcloud.com/#platform) provides SSO identity management. Cloudflare Access integrates with JumpCloud as a SAML identity provider.

The following steps are specific to setting up JumpCloud with Cloudflare Access. For more information on configuring JumpCloud SSO application, refer to the [JumpCloud documentation](https://jumpcloud.com/support/integrate-with-cloudflare).

## Set up Jumpcloud as a SAML provider

### 1. Create an SSO application in JumpCloud

1. In the [JumpCloud Admin Portal](https://console.jumpcloud.com/#/home), go to **SSO Applications**.

2. Select **Add New Application**.

3. In the search bar, enter `Cloudflare` and select the **Cloudflare Access** application.

4. Select **Next**.

5. In **Display Label**, enter an application name.

6. Select **Save Application**.

7. Review the application summary and select **Configure Application**.

8. In the **SSO** tab, configure the following settings:

   1. In **IdP Entity ID**, enter your Cloudflare team domain:

      ```txt
      https://<your-team-name>.cloudflareaccess.com/
      ```

      You can find your team name in [Cloudflare One](https://one.dash.cloudflare.com) under **Settings** > **Team name and domain** > **Team name**.

   2. Set both **SP Entity ID** and **ACS URL** to the following callback URL:

      ```txt
      https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
      ```

   3. (Optional) Configure SAML attributes that you want to send to Cloudflare Access.

   4. Scroll up to **JumpCloud Metadata** and select **Export Metadata**. Save this XML file for use in a [later step](#2-add-jumpcloud-to-zero-trust).

9. In the **User Groups** tab, [assign user groups](https://jumpcloud.com/support/get-started-applications-saml-sso#managing-employee-access-to-applications) to this application.

10. Select **Save**.

### 2. Add JumpCloud to Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Integrations** > **Identity providers**.

2. Under **Your identity providers**, select **Add new identity provider**.

3. Select **SAML**.

4. Upload your JumpCloud XML metadata file.

5. (Optional) To enable SCIM, refer to [Synchronize users and groups](#synchronize-users-and-groups).

6. (Optional) Under **Optional configurations**, configure [additional SAML options](#optional-configurations).

7. Select **Save**.

You can now [test your connection](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/#test-idps-in-cloudflare-one) and create [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) based on the configured login method and SAML attributes.

## Synchronize users and groups

The JumpCloud integration allows you to synchronize user groups and automatically deprovision users using [SCIM](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim/).

### 1. Enable SCIM in Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Integrations** > **Identity providers**.

2. Find the JumpCloud integration and select **Edit**.

3. Turn on **Enable SCIM**

4. (Optional) Configure the following settings:

* **Enable user deprovisioning**: [Revoke a user's active session](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/#per-user) when they are removed from the SCIM application in JumpCloud. This will invalidate all active Access sessions and prompt for reauthentication for any [WARP session policies](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/).

* **Remove user seat on deprovision**: [Remove a user's seat](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/seat-management/) from your Cloudflare One account when they are removed from the SCIM application in JumpCloud.

* **SCIM identity update behavior**: Choose what happens in Cloudflare One when the user's identity updates in JumpCloud.

  * *Automatic identity updates*: Automatically update the [User Registry identity](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/users/) when JumpCloud sends an updated identity or group membership through SCIM. This identity is used for Gateway policies and WARP [device profiles](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/); Access will read the user's updated identity when they reauthenticate.
  * *Group membership change reauthentication*: [Revoke a user's active session](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/#per-user) when their group membership changes in JumpCloud. This will invalidate all active Access sessions and prompt for reauthentication for any [WARP session policies](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/). Access will read the user's updated group membership when they reauthenticate.
  * *No action*: Update the user's identity the next time they reauthenticate to Access or WARP.

1. Select **Regenerate Secret**. Copy the **SCIM Endpoint** and **SCIM Secret**. You will need to enter these values into JumpCloud.

2. Select **Save**.

The SCIM secret never expires, but you can manually regenerate the secret at any time.

### 2. Configure SCIM in JumpCloud

1. In the [JumpCloud Admin Portal](https://console.jumpcloud.com/#/home), go to **SSO Applications**.
2. Select the Cloudflare application that was created when you [Set up JumpCloud as a SAML provider](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/jumpcloud-saml/#set-up-jumpcloud-as-a-saml-provider).
3. Select the **SSO** tab.
4. To provision user groups, select **Include group attribute** and enter `groups`. The group attribute name has to exactly match `groups` or else it will be sent as a SAML attribute.
5. Select the **Identity Management** tab.
6. Make sure that **Enable management of User Groups and Group Membership in this application** is turned on.
7. Select **Configure**.
8. In the **Base URL** field, enter the **SCIM Endpoint** obtained from Cloudflare One.
9. In the **Token Key** field, enter the **SCIM Secret** obtained from Cloudflare One.
10. Select **Activate**. You will receive a confirmation that the Identity Management integration has been successfully verified.
11. Select **Save**.

To check if user identities were updated in Cloudflare One, view your [SCIM provisioning logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/).

Note

New users must first [register the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/) or authenticate to an Access application before SCIM provisioning can begin.

### Provisioning attributes

Provisioning attributes define the user and group properties that JumpCloud will synchronize with Cloudflare Access. By default, JumpCloud will send the following attributes during a SCIM update event:

| JumpCloud user attribute | Cloudflare Access attribute |
| - | - |
| `email` | `email` |
| `firstname` | `givenName` |
| `lastname` | `surname` |

| JumpCloud group attribute | Cloudflare Access attribute |
| - | - |
| `name` | `groups` |

## Example API configuration

```json
{
  "config": {
    "issuer_url": "jumpcloud",
    "sso_target_url": "https://sso.myexample.jumpcloud.com/saml2/cloudflareaccess",
    "attributes": ["email", "name", "username"],
    "email_attribute_name": "",
    "sign_request": false,
    "idp_public_cert": "MIIDpDCCAoygAwIBAgIGAV2ka+55MA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEG\nA1UEC.....GF/Q2/MHadws97cZg\nuTnQyuOqPuHbnN83d/2l1NSYKCbHt24o"
  },
  "type": "saml",
  "name": "jumpcloud saml example"
}
```
