---
title: AI Gateway Introduces New Worker Binding Methods · Changelog
description: New Worker binding methods, enhancing integration capabilities for developers.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-01-26-worker-binding-methods/
  md: https://developers.cloudflare.com/changelog/2025-01-26-worker-binding-methods/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## AI Gateway Introduces New Worker Binding Methods

Jan 30, 2025

[AI Gateway](https://developers.cloudflare.com/ai-gateway/)

We have released new [Workers bindings API methods](https://developers.cloudflare.com/ai-gateway/integrations/worker-binding-methods/), allowing you to connect Workers applications to AI Gateway directly. These methods simplify how Workers calls AI services behind your AI Gateway configurations, removing the need to use the REST API and manually authenticate.

To add an AI binding to your Worker, include the following in your [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/):

![Add an AI binding to your Worker.](https://developers.cloudflare.com/_astro/add-binding.BoYTiyon_ZfGvTN.webp)

With the new AI Gateway binding methods, you can now:

* Send feedback and update metadata with `patchLog`.
* Retrieve detailed log information using `getLog`.
* Execute [universal requests](https://developers.cloudflare.com/ai-gateway/usage/universal/) to any AI Gateway provider with `run`.

For example, to send feedback and update metadata using `patchLog`:

![Send feedback and update metadata using patchLog:](https://developers.cloudflare.com/_astro/send-feedback.BGRzKmd9_qCKJ7.webp)
