---
title: Faster Workers Builds with Build Caching and Watch Paths · Changelog
description: Speed up your builds with build caching and build watch paths in
  Workers Builds (beta).
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2024-12-29-faster-builds/
  md: https://developers.cloudflare.com/changelog/2024-12-29-faster-builds/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Faster Workers Builds with Build Caching and Watch Paths

Dec 29, 2024

[Workers](https://developers.cloudflare.com/workers/)

![Build caching settings](https://developers.cloudflare.com/_astro/workers-build-caching.DWEh3Tj1_2mPjS.webp)![Build watch path settings](https://developers.cloudflare.com/_astro/workers-build-watch-paths.ClqD-iNq_2h8l42.webp)

[**Workers Builds**](https://developers.cloudflare.com/workers/ci-cd/builds/), the integrated CI/CD system for Workers (currently in beta), now lets you cache artifacts across builds, speeding up build jobs by eliminating repeated work, such as downloading dependencies at the start of each build.

* **[Build Caching](https://developers.cloudflare.com/workers/ci-cd/builds/build-caching/)**: Cache dependencies and build outputs between builds with a shared project-wide cache, ensuring faster builds for the entire team.

* **[Build Watch Paths](https://developers.cloudflare.com/workers/ci-cd/builds/build-watch-paths/)**: Define paths to include or exclude from the build process, ideal for [monorepos](https://developers.cloudflare.com/workers/ci-cd/builds/advanced-setups/#monorepos) to target only the files that need to be rebuilt per Workers project.

To get started, select your Worker on the [Cloudflare dashboard](https://dash.cloudflare.com) then go to **Settings** > **Builds**, and connect a GitHub or GitLab repository. Once connected, you'll see options to configure Build Caching and Build Watch Paths.
